*! version 1.0, 14 January 2003
*! B. Rachet, Ewbank et al. life table system

program define ewblft
version 7.0
	syntax varlist(max=1) [if],[by(string)] using(string) REF(string) AGE(string) /*
	*/[CENTER(string) GRaph METhod(string) CONSTraint(string)]

tempvar y ys fity
*						sum `age'
*tempfile master
sort `age' `by'
*save `master'
			save masterfile,replace
use "`using'"
sort `age' `by'
*						di "using"
*						sum `age'
*merge `age' `by' using `master'
			merge `age' `by' using masterfile
			cap erase masterfile.dta
		drop _merge
		tokenize `if',parse(" =&")
		local if1 `2'
		local if2 `6'
		local if3 `10'
		fillin `age' `if1' `if2' `if3'
		sort `age' `if1' `if2' `if3'
		qui by `age' `by':replace `ref'=`ref'[_N] if `ref'==.
		cap drop if `if1'==.
		cap drop if `if2'==.
		cap drop if `if3'==.
		qui replace `varlist'=1 if `age'==0
*						di "merge"
*						sum `age'
if "`if'" != "" {
	qui keep `if'
}
qui assert `age'>=0 & `age'!=.
*						di "after keep"
*						sum `age'
if "`center'" != "" {
	tokenize `center'
	local low `1'
	local high `2'
}
else {
	local low 40
	local high 60
}
	
qui gen `y'=.5*log((`varlist')/(1-`varlist'))
qui gen `ys'=.5*log((`ref')/(1-`ref'))
*						sum `age'

if "`method'" == "" | "`method'" == "4-parameter" | "`method'" == "3-parameter" {
	qui {
		reg `y' `ys' if `age'>=`low' & `age'<=`high'
	}
global b0=_b[_cons]
global b1=_b[`ys']
}

if "`method'" == "" | "`method'" == "4-parameter" {
	nl ewb `y' `ref'
	qui gen `fity' = _b[b0]+_b[b1]*(((`ref'/(1-`ref'))^_b[b2])-1)/(2*_b[b2]) if `ref'>.5
	qui replace `fity' = _b[b0]+_b[b1]*(1-((1-`ref')/`ref')^_b[b3])/(2*_b[b3]) if `ref'<=.5
	global method 4prm
}
if "`method'" == "3-parameter" {
	if "`constraint'" == "" {
		error 100
	}
	global constraint `constraint'
	tokenize $constraint,parse(" =+*")
	global parsup `1'
	global par1 `5'
	global coef1 `3'
	global coef2 `7'
		if "$coef2" == "" {
			global coef2 0
		}
	nl ewb3 `y' `ref'
	if "$par1" == "alpha" {
		local eq=$coef1*_b[b0]+$coef2
	}
	if "$par1" == "beta" {
		local eq=$coef1*_b[b1]+$coef2
	}
	
	if "$parsup" == "kappa" {
	qui gen `fity' = _b[b0]+_b[b1]*(((`ref'/(1-`ref'))^(`eq'))-1)/(2*(`eq')) if `ref'>.5
	qui replace `fity' = _b[b0]+_b[b1]*(1-((1-`ref')/`ref')^_b[b3])/(2*_b[b3]) if `ref'<=.5
	*/if `ref'<=.5
	}
	if "$parsup" == "lambda" {
	qui gen `fity' = _b[b0]+_b[b1]*(((`ref'/(1-`ref'))^_b[b2])-1)/(2*_b[b2]) if `ref'>.5
	qui replace `fity' = _b[b0]+_b[b1]*(1-((1-`ref')/`ref')^(`eq'))/(2*(`eq')) if `ref'<=.5
	}
global method 3prm
}

******************
*CHECK THIS PART!!!
******************
if "`method'" == "2-parameter" {
	reg `y' `ys'
	qui gen `fity' = _b[_cons]+_b[`ys']*`ys'
	global method 2prm
	global ys `ys'
}
******************
******************
qui gen fit`varlist' = exp(2*`fity')/(1+exp(2*`fity'))
qui replace fit`varlist'=1 if `age'==0
*						sum `age'

if "`graph'" != "" {
	if "`method'" == "" {
		local method 4-parameter
	}
	graph fit`varlist' `varlist' `age',xlabel ylabel(0 .5 1) s(.O) c(s) b2title("age") /*
	*/l2title("survival probability") b1(`method' life-table system `if')/*
	*/t2(Observed (o) vs. Smoothed (-) survival probabilities) /*
	*/saving(temp,replace)
}

end
