/**
 * Log likelihood for strel command
 * Version
 * 1.0 TB Jan 2007
 */

/*
 * lf method - much quicker than d2
 */
program define strel_ll
    version 8.2
    args lnf theta
    qui replace `lnf' = -ln(1/(`theta' + rate)) - `theta' * _py
end

/*
 * d2 method
program define strel_ll
    version 8.2
    args todo b lnf g negH
    tempvar theta lnfj
    mleval `theta' = `b'
    qui gen double `lnfj' = _d * (-ln(1/(`theta' + rate)) - `theta' * _py)
    mlsum `lnf' = `lnfj'
    if (`todo' == 0 | `lnf' >= .) exit 

    // First derivatives
    mlvecsum `lnf' `g' = _d * (1/(`theta' + rate) - _py)
    if (`todo' == 1 | `lnf' >= .) exit 

    // Second derivatives
    mlmatsum `lnf' `negH' = - _d * (1/(`theta' + rate)^2)
end
*/

